  
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_PAGTO_EQUALS]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].P_GERA_PAGTO_EQUALS
GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20220607
'Job.................:  
'Nome................: P_GERA_PAGTO_EQUALS
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: --
'Criado por..........: --
'Alterado por........: 
'=======================================================================================
FARMAGOI-23856

*/
CREATE   PROCEDURE P_GERA_PAGTO_EQUALS(
  @IDT_LOTE AS INT,
  @TIPO AS VARCHAR(100),
  @LOTE AS VARCHAR(100),
  @DT_MOV AS DATE, 
  @DT_VENCTO AS DATE,
  @VLR_BRUTO AS MONEY,
  @VLR_LIQUIDO AS MONEY,
  @VLR_TAXA AS MONEY,  
  @CD_FILIAL AS INT, 
  @CD_CLI AS INT, 
  @CD_USU AS INT, 
  @PARCELA_LOTE AS INT,
  @MODALIDADE AS INT,
  @NOME_ADQUIRENTE AS VARCHAR(100),
  @CD_BANDEIRA AS INT
) AS
SET NOCOUNT ON;
DECLARE @CD_CTR_LOTE INT
DECLARE @CD_GRP_ECON INT
DECLARE @CD_CTR INT
DECLARE @CD_CNT INT
DECLARE @CD_BC_LANC INT

SET @CD_CNT = ISNULL((SELECT x.CD_CNT FROM EQUALSCORE_CONFIG_CONTA x WHERE x.CD_FILIAL = @CD_FILIAL AND x.COD_BANDEIRA = @CD_BANDEIRA), 0)

IF @CD_CNT = 0
BEGIN
  RAISERROR('Conta nao configurada para a bandeira %d e filial %d', 16, 1, @CD_BANDEIRA, @CD_FILIAL)
  RETURN
END

SET @CD_CTR_LOTE = ISNULL((SELECT MAX(x.CD_CTR_LOTE) FROM RC_ADM_CARTAO_MOV_LOTE x), 0) + 1
SET @CD_GRP_ECON = (SELECT MAX(x.CD_GRP_ECON) FROM PRC_GRP_ECON_PRC_FILIAL x WHERE x.CD_FILIAL = @CD_FILIAL AND CD_EMP = 1)

INSERT INTO RC_ADM_CARTAO_MOV_LOTE(CD_CTR_LOTE, CD_GRP_ECON, DT_MOV, CD_FILIAL)
VALUES(@CD_CTR_LOTE, @CD_GRP_ECON, @DT_MOV, @CD_FILIAL);
--PK > CD_CTR_LOTE
--CD_GRP_ECON > PRC_GRP_ECON.CD_GRP_ECON

SET @CD_CTR = ISNULL((SELECT MAX(x.CD_CTR) FROM RC_ADM_CARTAO_MOV x), 0) + 1

INSERT INTO RC_ADM_CARTAO_MOV(CD_CTR, CD_GRP_ECON, CD_EMP, CD_CLI, TP_LANC, DT_LANC, DT_VENCTO, VLR_LANC, VLR_TAXA, HIST_LANC, CD_USU, DT_CAD, EXPT_CTB, FLAG_SLD_INI, CD_FILIAL, MODALIDADE)
VALUES(
  @CD_CTR, 
  @CD_GRP_ECON, 
  1, 
  @CD_CLI, 
  1,
  @DT_MOV, 
  @DT_VENCTO, 
  @VLR_LIQUIDO, 
  @VLR_TAXA, 
  'FECHAMENTO DE VENDAS DE CARTOES VENCTO DIA '+CAST(@DT_VENCTO AS  VARCHAR)+' FILIAL: '+CAST(@CD_FILIAL as VARCHAR(10)), 
  @CD_USU, 
  GETDATE(), 
  0, 0, 
  @CD_FILIAL, 
  @MODALIDADE
)

SELECT * FROM RC_ADM_CARTAO_MOV
--PK > CD_CTR
--CD_GRP_ECON > PRC_GRP_ECON.CD_GRP_ECON
--CD_EMP, CD_CLI > RC_CLI.CD_EMP.CD_CLI

INSERT INTO RC_ADM_CARTAO_MOV_BAIXA(CD_CTR_LOTE, CD_CTR, DT_CAD)
VALUES(@CD_CTR_LOTE, @CD_CTR, GETDATE());
--PK > CD_CTR_LOTE, CD_CTR
--CD_CTR > RC_ADM_CARTAO_MOV.CD_CTR

INSERT INTO RC_ADM_CARTAO_MOV_LOTE_RC_ADM_CARTAO_MOV(CD_CTR_LOTE, CD_CTR)
VALUES(@CD_CTR_LOTE, @CD_CTR);
--PK > CD_CTR_LOTE, CD_CTR
--CD_CTR_LOTE > RC_ADM_CARTAO_MOV_LOTE.CD_CTR_LOTE
--CD_CTR > RC_ADM_CARTAO_MOV.CD_CTR

INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_RC_ADM_CARTAO_MOV(IDT_LOTE, PARCELA_LOTE, CD_CTR_LOTE, CD_CTR)
VALUES(@IDT_LOTE, @PARCELA_LOTE, @CD_CTR_LOTE, @CD_CTR);
--PK > IDT_LOTE, PARCELA_LOTE, CD_CTR_LOTE, CD_CTR
--CD_CTR_LOTE, CD_CTR > RC_ADM_CARTAO_MOV_LOTE_RC_ADM_CARTAO_MOV.CD_CTR_LOTE.CD_CTR

SET @CD_BC_LANC = ISNULL((SELECT MAX(x.CD_BC_LANC) FROM BC_LANC x), 0) + 1

INSERT INTO BC_LANC(CD_EMP, CD_BC_LANC, VLR_LANC, CD_CNT, HIST_LANC, CD_DOC, TP_LANC, DT_LANCTO, DT_CAD, CD_USU, FC, CD_TP_LANC, SLD_INI, ORIG_LANC, DT_COMP)
VALUES(
  1, 
  @CD_BC_LANC, 
  @VLR_LIQUIDO, 
  @CD_CNT,
  'RECEBIMENTO OPERADORA DE CARTO: '+UPPER(@NOME_ADQUIRENTE)+' - '+(CASE @MODALIDADE WHEN 0 THEN 'CREDITO' WHEN 1 THEN 'DEBITO' END), 
  1, 
  0,
  @DT_MOV, 
  GETDATE(), 
  @CD_USU, 
  0, 
  59, 
  0, 
  0, 
  @DT_MOV
)
--PK > CD_EMP, CD_BC_LANC
--CD_EMP, CD_CNT > BC_CONTAS.CD_EMP.CD_CNT
--CD_EMP, CD_TP_LANC > RC_TP_LANC.CD_EMP.CD_TP_LANC

